/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Named;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.component.DefaultSoftwareComponentVariant;
import org.gradle.api.internal.component.UsageContext;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.internal.NativeVariantIdentity;
import org.gradle.language.nativeplatform.internal.BuildType;
import org.gradle.nativeplatform.Linkage;
import org.gradle.nativeplatform.MachineArchitecture;
import org.gradle.nativeplatform.OperatingSystemFamily;
import org.gradle.nativeplatform.TargetMachine;
import org.gradle.nativeplatform.TargetMachineFactory;
import org.gradle.nativeplatform.internal.DefaultTargetMachineFactory;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;

public class Dimensions {
    public static String createDimensionSuffix(Named dimensionValue, Collection<?> multivalueProperty) {
        return Dimensions.createDimensionSuffix(dimensionValue.getName(), multivalueProperty);
    }

    public static String createDimensionSuffix(String dimensionValue, Collection<?> multivalueProperty) {
        if (Dimensions.isDimensionVisible(multivalueProperty)) {
            return StringUtils.capitalize((String)dimensionValue.toLowerCase(Locale.ROOT));
        }
        return "";
    }

    private static boolean isDimensionVisible(Collection<?> multivalueProperty) {
        return multivalueProperty.size() > 1;
    }

    public static void unitTestVariants(Provider<String> baseName, SetProperty<TargetMachine> declaredTargetMachines, @Nullable SetProperty<TargetMachine> declaredTargetMachinesOfTestedComponent, ObjectFactory objectFactory, AttributesFactory attributesFactory, Provider<String> group, Provider<String> version, Action<NativeVariantIdentity> action) {
        Collection<TargetMachine> targetMachines = Dimensions.extractAndValidate("target machine", "unit test", declaredTargetMachines);
        if (declaredTargetMachinesOfTestedComponent != null) {
            Collection<TargetMachine> targetMachinesOfTestedComponent = Dimensions.extractAndValidate("target machine", "component under test", declaredTargetMachinesOfTestedComponent);
            Dimensions.validateTargetMachines(targetMachines, targetMachinesOfTestedComponent);
        }
        Dimensions.variants(baseName, Arrays.asList(BuildType.DEBUG), targetMachines, objectFactory, attributesFactory, group, version, action);
    }

    public static void applicationVariants(Provider<String> baseName, SetProperty<TargetMachine> declaredTargetMachines, ObjectFactory objectFactory, AttributesFactory attributesFactory, Provider<String> group, Provider<String> version, Action<NativeVariantIdentity> action) {
        Collection<BuildType> buildTypes = BuildType.DEFAULT_BUILD_TYPES;
        Collection<TargetMachine> targetMachines = Dimensions.extractAndValidate("target machine", "application", declaredTargetMachines);
        Dimensions.variants(baseName, buildTypes, targetMachines, objectFactory, attributesFactory, group, version, action);
    }

    public static void libraryVariants(Provider<String> baseName, SetProperty<Linkage> declaredLinkages, SetProperty<TargetMachine> declaredTargetMachines, ObjectFactory objectFactory, AttributesFactory attributesFactory, Provider<String> group, Provider<String> version, Action<NativeVariantIdentity> action) {
        Collection<BuildType> buildTypes = BuildType.DEFAULT_BUILD_TYPES;
        Collection<Linkage> linkages = Dimensions.extractAndValidate("linkage", "library", declaredLinkages);
        Collection<TargetMachine> targetMachines = Dimensions.extractAndValidate("target machine", "library", declaredTargetMachines);
        Dimensions.variants(baseName, buildTypes, linkages, targetMachines, objectFactory, attributesFactory, group, version, action);
    }

    private static <T> Collection<T> extractAndValidate(String propertyName, String componentName, SetProperty<T> declared) {
        declared.finalizeValue();
        Collection value = (Collection)declared.get();
        Dimensions.assertNonEmpty(propertyName, componentName, value);
        return value;
    }

    private static void assertNonEmpty(String propertyName, String componentName, Collection<?> property) {
        if (property.isEmpty()) {
            throw new IllegalArgumentException(String.format("A %s needs to be specified for the %s.", propertyName, componentName));
        }
    }

    private static void validateTargetMachines(Collection<TargetMachine> testTargetMachines, Collection<TargetMachine> mainTargetMachines) {
        for (TargetMachine machine : testTargetMachines) {
            if (mainTargetMachines.contains(machine)) continue;
            throw new IllegalArgumentException("The target machine " + machine.toString() + " was specified for the unit test, but this target machine was not specified on the component under test.");
        }
    }

    private static void variants(Provider<String> baseName, Collection<BuildType> buildTypes, Collection<Linkage> linkages, Collection<TargetMachine> targetMachines, ObjectFactory objectFactory, AttributesFactory attributesFactory, Provider<String> group, Provider<String> version, Action<NativeVariantIdentity> action) {
        for (BuildType buildType : buildTypes) {
            for (Linkage linkage : linkages) {
                for (TargetMachine targetMachine : targetMachines) {
                    Usage runtimeUsage = (Usage)objectFactory.named(Usage.class, "native-runtime");
                    Usage linkUsage = (Usage)objectFactory.named(Usage.class, "native-link");
                    ArrayList<String> variantNameToken = new ArrayList<String>();
                    variantNameToken.add(buildType.getName());
                    variantNameToken.add(Dimensions.createDimensionSuffix((Named)linkage, linkages));
                    variantNameToken.add(Dimensions.createDimensionSuffix((Named)targetMachine.getOperatingSystemFamily(), Dimensions.targetMachinesToOperatingSystems(targetMachines)));
                    variantNameToken.add(Dimensions.createDimensionSuffix((Named)targetMachine.getArchitecture(), Dimensions.targetMachinesToArchitectures(targetMachines)));
                    String variantName = StringUtils.uncapitalize((String)String.join((CharSequence)"", variantNameToken));
                    AttributeContainerInternal runtimeAttributes = attributesFactory.mutable();
                    runtimeAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
                    Dimensions.addCommonAttributes(buildType, targetMachine, (AttributeContainer)runtimeAttributes);
                    runtimeAttributes.attribute(CppBinary.LINKAGE_ATTRIBUTE, (Object)linkage);
                    DefaultSoftwareComponentVariant runtimeVariant = new DefaultSoftwareComponentVariant(variantName + "Runtime", (AttributeContainer)runtimeAttributes);
                    AttributeContainerInternal linkAttributes = attributesFactory.mutable();
                    linkAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)linkUsage);
                    Dimensions.addCommonAttributes(buildType, targetMachine, (AttributeContainer)linkAttributes);
                    linkAttributes.attribute(CppBinary.LINKAGE_ATTRIBUTE, (Object)linkage);
                    DefaultSoftwareComponentVariant linkVariant = new DefaultSoftwareComponentVariant(variantName + "Link", (AttributeContainer)linkAttributes);
                    NativeVariantIdentity variantIdentity = new NativeVariantIdentity(variantName, baseName, group, version, buildType.isDebuggable(), buildType.isOptimized(), targetMachine, (UsageContext)linkVariant, (UsageContext)runtimeVariant, linkage);
                    action.execute((Object)variantIdentity);
                }
            }
        }
    }

    private static void variants(Provider<String> baseName, Collection<BuildType> buildTypes, Collection<TargetMachine> targetMachines, ObjectFactory objectFactory, AttributesFactory attributesFactory, Provider<String> group, Provider<String> version, Action<NativeVariantIdentity> action) {
        for (BuildType buildType : buildTypes) {
            for (TargetMachine targetMachine : targetMachines) {
                Usage runtimeUsage = (Usage)objectFactory.named(Usage.class, "native-runtime");
                ArrayList<String> variantNameToken = new ArrayList<String>();
                variantNameToken.add(buildType.getName());
                variantNameToken.add(Dimensions.createDimensionSuffix((Named)targetMachine.getOperatingSystemFamily(), Dimensions.targetMachinesToOperatingSystems(targetMachines)));
                variantNameToken.add(Dimensions.createDimensionSuffix((Named)targetMachine.getArchitecture(), Dimensions.targetMachinesToArchitectures(targetMachines)));
                String variantName = StringUtils.uncapitalize((String)String.join((CharSequence)"", variantNameToken));
                AttributeContainerInternal runtimeAttributes = attributesFactory.mutable();
                runtimeAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
                Dimensions.addCommonAttributes(buildType, targetMachine, (AttributeContainer)runtimeAttributes);
                DefaultSoftwareComponentVariant runtimeVariant = new DefaultSoftwareComponentVariant(variantName + "Runtime", (AttributeContainer)runtimeAttributes);
                UsageContext linkVariant = null;
                NativeVariantIdentity variantIdentity = new NativeVariantIdentity(variantName, baseName, group, version, buildType.isDebuggable(), buildType.isOptimized(), targetMachine, linkVariant, (UsageContext)runtimeVariant, null);
                action.execute((Object)variantIdentity);
            }
        }
    }

    private static Set<OperatingSystemFamily> targetMachinesToOperatingSystems(Collection<TargetMachine> targetMachines) {
        return targetMachines.stream().map(TargetMachine::getOperatingSystemFamily).collect(Collectors.toSet());
    }

    private static Set<MachineArchitecture> targetMachinesToArchitectures(Collection<TargetMachine> targetMachines) {
        return targetMachines.stream().map(TargetMachine::getArchitecture).collect(Collectors.toSet());
    }

    private static void addCommonAttributes(BuildType buildType, TargetMachine targetMachine, AttributeContainer runtimeAttributes) {
        runtimeAttributes.attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)buildType.isDebuggable());
        runtimeAttributes.attribute(CppBinary.OPTIMIZED_ATTRIBUTE, (Object)buildType.isOptimized());
        runtimeAttributes.attribute(MachineArchitecture.ARCHITECTURE_ATTRIBUTE, (Object)targetMachine.getArchitecture());
        runtimeAttributes.attribute(OperatingSystemFamily.OPERATING_SYSTEM_ATTRIBUTE, (Object)targetMachine.getOperatingSystemFamily());
    }

    public static Set<TargetMachine> useHostAsDefaultTargetMachine(TargetMachineFactory targetMachineFactory) {
        return Collections.singleton(((DefaultTargetMachineFactory)targetMachineFactory).host());
    }

    public static boolean tryToBuildOnHost(NativeVariantIdentity identity) {
        return DefaultNativePlatform.getCurrentOperatingSystem().toFamilyName().equals(identity.getTargetMachine().getOperatingSystemFamily().getName());
    }
}

