/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.DependencySubstitution;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ComponentSelectionDescriptor;
import org.gradle.api.internal.artifacts.DependencySubstitutionInternal;
import org.gradle.api.internal.artifacts.ProjectComponentIdentifierInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasons;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.internal.Pair;
import org.gradle.internal.component.local.model.DefaultProjectComponentSelector;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeBuildDependencySubstitutions
implements Action<DependencySubstitution> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeBuildDependencySubstitutions.class);
    private final Multimap<ModuleIdentifier, ProjectComponentIdentifier> replacementMap = ArrayListMultimap.create();

    public CompositeBuildDependencySubstitutions(Collection<Pair<ModuleVersionIdentifier, ProjectComponentIdentifier>> replacements) {
        for (Pair<ModuleVersionIdentifier, ProjectComponentIdentifier> replacement : replacements) {
            this.replacementMap.put((Object)((ModuleVersionIdentifier)replacement.getLeft()).getModule(), (Object)((ProjectComponentIdentifier)replacement.getRight()));
        }
    }

    public void execute(DependencySubstitution sub) {
        ModuleComponentSelector selector;
        ProjectComponentIdentifierInternal replacement;
        DependencySubstitutionInternal dependencySubstitution = (DependencySubstitutionInternal)sub;
        ComponentSelector requested = dependencySubstitution.getTarget();
        if (requested instanceof ModuleComponentSelector && (replacement = this.getReplacementFor(selector = (ModuleComponentSelector)requested)) != null) {
            DefaultProjectComponentSelector targetProject = new DefaultProjectComponentSelector(replacement.getProjectIdentity(), ((AttributeContainerInternal)requested.getAttributes()).asImmutable(), ImmutableSet.copyOf((Collection)requested.getCapabilitySelectors()));
            dependencySubstitution.useTarget((Object)targetProject, (ComponentSelectionDescriptor)ComponentSelectionReasons.COMPOSITE_BUILD);
        }
    }

    @Nullable
    private ProjectComponentIdentifierInternal getReplacementFor(ModuleComponentSelector selector) {
        ModuleIdentifier candidateId = selector.getModuleIdentifier();
        Collection providingProjects = this.replacementMap.get((Object)candidateId);
        if (providingProjects.isEmpty()) {
            LOGGER.debug("Found no composite build substitute for module '{}'.", (Object)candidateId);
            return null;
        }
        if (providingProjects.size() == 1) {
            ProjectComponentIdentifier match = (ProjectComponentIdentifier)providingProjects.iterator().next();
            LOGGER.info("Found project '{}' as substitute for module '{}'.", (Object)match, (Object)candidateId);
            return (ProjectComponentIdentifierInternal)match;
        }
        throw new ModuleVersionResolveException((ComponentSelector)selector, () -> {
            SortedSet sortedProjects = providingProjects.stream().map(ComponentIdentifier::getDisplayName).collect(Collectors.toCollection(TreeSet::new));
            return String.format("Module version '%s' is not unique in composite: can be provided by %s.", selector.getDisplayName(), sortedProjects);
        });
    }
}

