/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.internal.AbstractTerminal;
import net.rubygrapefruit.platform.internal.AnsiTerminals;
import net.rubygrapefruit.platform.terminal.TerminalInput;
import net.rubygrapefruit.platform.terminal.TerminalOutput;
import net.rubygrapefruit.platform.terminal.Terminals;

public abstract class AbstractTerminals
implements Terminals {
    private final Object lock = new Object();
    private Terminals.Output currentlyOpen;
    private AbstractTerminal currentOutput;
    private TerminalInput currentInput;

    public Terminals withAnsiOutput() {
        return new AnsiTerminals(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput getTerminal(Terminals.Output output) {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentlyOpen != null && this.currentlyOpen != output) {
                throw new UnsupportedOperationException("Currently only one output can be used as a terminal.");
            }
            if (this.currentOutput == null) {
                final AbstractTerminal terminal = this.createTerminal(output);
                terminal.init();
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    public void run() {
                        terminal.reset();
                    }
                });
                this.currentlyOpen = output;
                this.currentOutput = terminal;
            }
            return this.currentOutput;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalInput getTerminalInput() throws NativeException {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentInput == null) {
                this.currentInput = this.createInput();
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    public void run() {
                        AbstractTerminals.this.currentInput.reset();
                    }
                });
            }
            return this.currentInput;
        }
    }

    protected abstract TerminalInput createInput();

    protected abstract AbstractTerminal createTerminal(Terminals.Output var1);
}

