/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.diagnostic.PluginException;
import org.jetbrains.kotlin.com.intellij.openapi.application.Application;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.ex.ApplicationManagerEx;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentFactoryMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

final class CachedValueStabilityChecker {
    private static final Logger LOG = Logger.getInstance(CachedValueStabilityChecker.class);
    private static final Set<String> ourReportedKeys = ContainerUtil.newConcurrentSet();
    private static final ConcurrentMap<Class<?>, List<Field>> ourFieldCache = ConcurrentFactoryMap.createMap(ReflectionUtil::collectFields);
    private static final boolean DO_CHECKS = CachedValueStabilityChecker.shouldDoChecks();

    CachedValueStabilityChecker() {
    }

    private static boolean shouldDoChecks() {
        Application app = ApplicationManager.getApplication();
        return app.isUnitTestMode() || app.isInternal() || app.isEAP();
    }

    static void checkProvidersEquivalent(CachedValueProvider<?> p1, CachedValueProvider<?> p2, Key<?> key) {
        if (p1 == p2 || !DO_CHECKS || ApplicationManagerEx.isInStressTest()) {
            return;
        }
        if (p1.getClass() != p2.getClass()) {
            if (!CachedValueStabilityChecker.seemConcurrentlyCreatedLambdas(p1.getClass(), p2.getClass())) {
                CachedValueStabilityChecker.complain("Incorrect CachedValue use: different providers supplied for the same key: " + p1 + " and " + p2, key.toString(), p1.getClass());
            }
            return;
        }
        CachedValueStabilityChecker.checkFieldEquivalence(p1, p2, key.toString(), 0, p1.getClass());
    }

    private static boolean seemConcurrentlyCreatedLambdas(Class<?> c1, Class<?> c2) {
        if (c1 == c2) {
            return false;
        }
        String name1 = c1.getName();
        String name2 = c2.getName();
        int index = name1.indexOf("$$Lambda");
        return index > 0 && index == name2.indexOf("$$Lambda") && name2.startsWith(name1.substring(0, index)) && ((List)ourFieldCache.get(c1)).size() == ((List)ourFieldCache.get(c2)).size();
    }

    private static boolean checkFieldEquivalence(Object o1, Object o2, String key, int depth, @NotNull Class<?> pluginClass) {
        if (pluginClass == null) {
            CachedValueStabilityChecker.$$$reportNull$$$0(0);
        }
        if (depth > 100) {
            CachedValueStabilityChecker.complain("Too deep function delegation inside CachedValueProvider. If you have cyclic dependencies, please remove them.", key, pluginClass);
            return false;
        }
        for (Field field : (List)ourFieldCache.get(o1.getClass())) {
            Object v2;
            Object v1;
            try {
                field.setAccessible(true);
                v1 = field.get(o1);
                v2 = field.get(o2);
            }
            catch (Exception e) {
                throw new UnsupportedOperationException("Please allow full reflective access");
            }
            if (CachedValueStabilityChecker.areEqual(v1, v2) || v1 != null && v2 != null && CachedValueStabilityChecker.seemConcurrentlyCreatedLambdas(v1.getClass(), v2.getClass())) continue;
            if (v1 != null && v2 != null && v1.getClass() == v2.getClass() && CachedValueStabilityChecker.shouldGoDeeper(v1)) {
                if (CachedValueStabilityChecker.checkFieldEquivalence(v1, v2, key, depth + 1, v1.getClass())) continue;
                return false;
            }
            CachedValueStabilityChecker.complain(CachedValueStabilityChecker.nonEquivalence(o1.getClass(), field, v1, v2), key, pluginClass);
            return false;
        }
        return true;
    }

    private static boolean areEqual(Object v1, Object v2) {
        if (Objects.equals(v1, v2)) {
            return true;
        }
        if (v1 instanceof Object[] && v2 instanceof Object[]) {
            return Arrays.deepEquals((Object[])v1, (Object[])v2);
        }
        if (v1 instanceof Reference && v2 instanceof Reference) {
            return Objects.equals(((Reference)v1).get(), ((Reference)v2).get());
        }
        return false;
    }

    @NotNull
    @NonNls
    private static String nonEquivalence(Class<?> objectClass, Field field, @Nullable Object v1, @Nullable Object v2) {
        String string2 = "Incorrect CachedValue use: same CV with different captured context, this can cause unstable results and invalid PSI access.\nField " + field.getName() + " in " + objectClass + " has non-equivalent values:\n  " + v1 + (v1 == null ? "" : " (" + v1.getClass().getName() + ")") + " and\n  " + v2 + (v2 == null ? "" : " (" + v2.getClass().getName() + ")") + "\nEither make `equals()` hold for these values, or avoid this dependency, e.g. by extracting CV provider into a static method.";
        if (string2 == null) {
            CachedValueStabilityChecker.$$$reportNull$$$0(1);
        }
        return string2;
    }

    private static void complain(@NonNls String message, String key, @NotNull Class<?> pluginClass) {
        if (pluginClass == null) {
            CachedValueStabilityChecker.$$$reportNull$$$0(2);
        }
        if (ourReportedKeys.add(key)) {
            PluginException.logPluginError(LOG, message, null, pluginClass);
        }
    }

    private static boolean shouldGoDeeper(Object o) {
        if (o instanceof CachedValueProvider) {
            return true;
        }
        Class<?> clazz = o.getClass();
        Class<?> superclass = clazz.getSuperclass();
        if (superclass == null) {
            return false;
        }
        if ((o instanceof Supplier || o instanceof Function) && Object.class.equals(clazz.getSuperclass())) {
            return true;
        }
        return "kotlin.jvm.internal.Lambda".equals(superclass.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/CachedValueStabilityChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/CachedValueStabilityChecker";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "nonEquivalence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkFieldEquivalence";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "complain";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

