/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel;

import java.util.Arrays;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.internal.tasks.DefaultSourceSetContainer;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.instrumentation.api.annotations.NotToBeReplacedByLazyProperty;
import org.gradle.internal.instrumentation.api.annotations.ToBeReplacedByLazyProperty;
import org.gradle.plugin.devel.PluginDeclaration;

public abstract class GradlePluginDevelopmentExtension {
    private final SourceSetContainer testSourceSets;
    private SourceSet pluginSourceSet;
    private boolean automatedPublishing = true;

    public GradlePluginDevelopmentExtension(Project project, SourceSet pluginSourceSet, SourceSet testSourceSet) {
        this.pluginSourceSet = pluginSourceSet;
        this.testSourceSets = (SourceSetContainer)project.getObjects().newInstance(DefaultSourceSetContainer.class, new Object[0]);
        this.testSourceSets(testSourceSet);
    }

    @Deprecated
    public GradlePluginDevelopmentExtension(Project project, SourceSet pluginSourceSet, SourceSet[] testSourceSets) {
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(GradlePluginDevelopmentExtension.class, (String)"<init>(Project, SourceSet, SourceSet[])").withAdvice("Do not create this object directly.")).willBeRemovedInGradle9().withUpgradeGuideSection(8, "deprecated_plugin_development_methods")).nagUser();
        this.pluginSourceSet = pluginSourceSet;
        this.testSourceSets = (SourceSetContainer)project.getObjects().newInstance(DefaultSourceSetContainer.class, new Object[0]);
        this.testSourceSets(testSourceSets);
    }

    @Deprecated
    public void pluginSourceSet(SourceSet pluginSourceSet) {
        this.pluginSourceSet = pluginSourceSet;
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(GradlePluginDevelopmentExtension.class, (String)"pluginSourceSet(SourceSet)").withAdvice("Use the main source set.")).willBeRemovedInGradle9().withUpgradeGuideSection(8, "deprecated_plugin_development_methods")).nagUser();
    }

    @Incubating
    public void testSourceSet(SourceSet testSourceSet) {
        this.testSourceSets.add((Object)testSourceSet);
    }

    public void testSourceSets(SourceSet ... testSourceSets) {
        this.testSourceSets.clear();
        this.testSourceSets.addAll(Arrays.asList(testSourceSets));
    }

    @NotToBeReplacedByLazyProperty(because="this property will be made non-configurable")
    public SourceSet getPluginSourceSet() {
        return this.pluginSourceSet;
    }

    @NotToBeReplacedByLazyProperty(because="this property will be replaced by another API")
    public Set<SourceSet> getTestSourceSets() {
        return this.testSourceSets;
    }

    public abstract Property<String> getWebsite();

    public abstract Property<String> getVcsUrl();

    public abstract NamedDomainObjectContainer<PluginDeclaration> getPlugins();

    public void plugins(Action<? super NamedDomainObjectContainer<PluginDeclaration>> action) {
        action.execute(this.getPlugins());
    }

    @ToBeReplacedByLazyProperty
    public boolean isAutomatedPublishing() {
        return this.automatedPublishing;
    }

    public void setAutomatedPublishing(boolean automatedPublishing) {
        this.automatedPublishing = automatedPublishing;
    }
}

