/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.remote.internal.inet;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import javax.annotation.Nullable;
import org.gradle.internal.remote.internal.inet.InetAddresses;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceScope(value={Scope.Global.class})
public class InetAddressFactory {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Object lock = new Object();
    private InetAddress localBindingAddress;
    private InetAddress wildcardBindingAddress;
    private InetAddresses inetAddresses;
    private boolean initialized;

    public boolean isCommunicationAddress(InetAddress address) {
        return this.getLocalBindingAddress().equals(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress getLocalBindingAddress() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.init();
                return this.localBindingAddress;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not determine a usable local IP for this machine.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress getWildcardBindingAddress() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.init();
                return this.wildcardBindingAddress;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not determine a usable wildcard IP for this machine.", e);
        }
    }

    private void init() throws Exception {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.inetAddresses == null) {
            this.inetAddresses = new InetAddresses();
        }
        this.wildcardBindingAddress = new InetSocketAddress(0).getAddress();
        this.findLocalBindingAddress();
        this.handleOpenshift();
    }

    private void findLocalBindingAddress() {
        if (this.inetAddresses.getLoopback().isEmpty()) {
            this.logger.debug("No loopback address for local binding, using fallback {}", (Object)this.wildcardBindingAddress);
            this.localBindingAddress = this.wildcardBindingAddress;
        } else {
            this.localBindingAddress = InetAddress.getLoopbackAddress();
        }
    }

    private void handleOpenshift() {
        InetAddress openshiftBindAddress = this.findOpenshiftAddresses();
        if (openshiftBindAddress != null) {
            this.localBindingAddress = openshiftBindAddress;
        }
    }

    @Nullable
    private InetAddress findOpenshiftAddresses() {
        for (String key : System.getenv().keySet()) {
            if (!key.startsWith("OPENSHIFT_") || !key.endsWith("_IP")) continue;
            String ipAddress = System.getenv(key);
            this.logger.debug("OPENSHIFT IP environment variable {} detected. Using IP address {}.", (Object)key, (Object)ipAddress);
            try {
                return InetAddress.getByName(ipAddress);
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(String.format("Unable to use OPENSHIFT IP - invalid IP address '%s' specified in environment variable %s.", ipAddress, key), e);
            }
        }
        return null;
    }
}

